# some functions

quantize <- function(x, breaks=NULL, nbin= NULL) {
  if (is.null(breaks)) {
    if (is.null(nbin)) {
      print("needs nbin, the number of bins")
      return()
    }else{
      length(breaks <- quantile(x, 0:nbin/nbin))
    }
  }
  labels <- (length(breaks)-2):0

  q <- findInterval(x, vec=breaks,T,T)
  return(q)
}

#source("MaxCorr.Quantization.R")
# function merg_quant written in C

get.max.corr <- function(data, bl,nbin=NULL)  {
  if (!is.null(nbin)) {
    bl <- list()
    for (i in 1:2)
      bl[[i]] <- quantile(data[,i], 0:nbin/nbin)
  }

  nbin <-
    ( length(bl[[1]]) - 1)

  q.n0 <- data
  for (i in 1:2)       q.n0[,i] <- quantize(x=data[,i], breaks=bl[[i]])

  c0 <- abs(cor(q.n0) [1,2])   # initial corre

#  i = nbin
  for (i in nbin:2) {
    print(i)

    junk <- merge_quant(q.n0=q.n0, nbin=i)
    str(junk)
    q.n0 <- junk$q
    str(q.n0)
    if (junk$nbin == i) break
  }

  qcut <- round(c(0, cumsum(table(q.n0[,1])/nrow(q.n0))),3 )
  
  for (i in 1:2)
    bl[[i]] <- quantile(data[,i], qcut)

  max.corr <- abs(cor(q.n0)[1,2])
  
  return(list(bl=bl,max.corr=max.corr,q=q.n0))
}

 #====== 
scat.plot.quantization <- function(data=NULL, QCC=NULL, nbin=100, xylim=NULL,plot =TRUE,index=NULL,mtexts=c("A","B"),mfrow=c(1,2)) {
  if (!is.null(data)) {
    corr.o <-
      round( cor(data)[1,2] ,3)
    main.o <- paste("Before quantization ( Corr. coeff.= ", corr.o, " )", sep="")
  }
  
  if (is.null(QCC)) {
    if (is.null(data)) {
     print("need data to generate QCC")
     return()
    }else{
      QCC <-  get_max_corr(data=data, nbin=nbin)
    }
  }
  
  corr.n <-
    round(QCC$max.corr,3)
  sub("%", "",names(QCC$bl[[1]]))
  sub <-
    paste(" [Cutoffs(%): ", paste(sub("%","",names(QCC$bl[[1]])), collapse=","),"]",  sep="")

  main.n <- paste("After quantization (|Corr. coeff.|= ", corr.n, " )\n",sub, sep="")

  i=0;
  if (plot) {
    if (!is.null(mfrow)) par(mfrow=mfrow)
    if (!is.null(data)) {
      scat.plot(data,main=main.o,index=index,xlim=xylim,ylim=xylim); i=i+1
      mtext(mtexts[i], side=3,adj=-0.1,cex=1.5,line=2,font=2)
    }
    if (!is.null(QCC)) {
      scat.plot(jitter(QCC$q),main=main.n,index=index); i=i+1
      mtext(mtexts[i], side=3,adj=-0.1,cex=1.5,line=2,font=2)
    }
  }
  return(QCC)
}


addNoise <- function(dat, sigma=1, ran=NULL) {
  n <- length(dat)
  if (is.null(ran)) ran <- rnorm(n)
  if (length(ran) != n) {
    print("lengths do not match for data and ran")
    return()
  }
  return(dat+sigma*ran)
}

library(MASS)
scat.plot <- function(data, sample=3000,pch=".",main="ChIP-chip",
                      xlim=NULL,ylim=NULL,xlab=NULL,ylab=NULL,
                      index=NULL, legend=NULL,
                      cex=1.5, cex.lab=1.5, cex.axis=1.5,
                      plot.contour=FALSE,levels=seq(0.01,0.05,0.01),n=30,
                      show.cor=F){
  
  if (is.null(xlab))
    xlab <-  colnames(data)[1]
  if (is.null(ylab))
    ylab <-  colnames(data)[2]
  
  M <- data[,2]; A <- data[,1]

  if (show.cor) {
    cor.all <- round(cor(M,A),2)
    if (length(M) != length(c(index.2L.F,index.4.F,index.X.F))) {
      main <- paste(main, " (Corr.coeff.: ", cor.all,")", sep="")
    }else{
      cor.X <- round(cor(M[index.X.F],A[index.X.F]),2)
      cor.2L <- round(cor(M[index.2L.F],A[index.2L.F]),2)
      main <- paste(main, " Corr.coeff.: ", cor.all," (", cor.X,"[X] / ",cor.2L, "[2L])", sep="")
    }
  }
  
  plot.MA(M=M, A=A, sample=sample, pch=pch, main=main,
                 xlim=xlim, ylim=ylim, xlab=xlab,ylab=ylab,index=index,
                 legend=legend, cex=cex, cex.lab=cex.lab, cex.axis=cex.axis,
                 plot.contour=plot.contour, levels=levels, n=n)

  abline(a=0,b=1, col=1, lwd=2,lty=2)

  return()  
}
  
plot.MA <- function(M,A, sample=3000,pch=".",main="ChIP-chip",
                    xlim=NULL,ylim=NULL,xlab="A (intensity)",ylab="M (log ratio)",
                    index=NULL, legend=NULL,
                    cex=1.5, cex.lab=1.5, cex.axis=1.5,
                    plot.contour=FALSE,levels=seq(0.01,0.05,0.01),n=30){

  if (length(A) == (length(index.2L.F)+ length(index.X.F)+ length(index.4.F))) {
    index <- 
      list(Chr.X= index.X.F,Chr.2L = index.2L.F)
#    print(names(index))
  }
  
  if (is.null(index)){
    index.1 <- 1:length(A)
    index.2 <- NULL
  }else{
    index.1 <- index[[1]]
    index.2 <- index[[2]]
    legend=names(index)
  }
      
  if (is.null(xlim))   xlim <- c(floor(min(A)),ceiling(max(A)))
  if (is.null(ylim))   ylim <- c(floor(min(M)),ceiling(max(M)))
  if (is.null(sample)){
    id.1 <- index.1
    id.2 <- index.2
  }else{
    if (length(index.1)> sample) {
      id.1 <- sample(index.1,size=sample)
    }else{
      id.1 <- index.1
    }
    if (length(index.2)> sample){
      id.2 <- sample(index.2,size=sample)
    }else{
      id.2 <- index.2
    }
  }
  plot(A[id.1],M[id.1],pch=pch,col=2, xlab=xlab,ylab=ylab,xlim=xlim,ylim=ylim, yaxs="i", xaxs="i",
       main=main,cex.lab=cex.lab,cex.axis=cex.axis)

  abline(h=0, col="gray", lwd=2,lty=2)
  abline(v=0, col="gray", lwd=2,lty=2)
#  abline(a=0,b=1, col=1, lwd=2,lty=2)

  if (length(id.2)>0) {
    points(A[id.2],M[id.2],pch=pch,col=4)
    if (!is.null(legend)) {
  #    legend <- c("X", "2L")
      legend("topleft",legend=legend,text.col=c(2,4))
    }
  }

  box(lwd=1.5)
  
  if (plot.contour == TRUE){
#    levels <- seq(0.01,0.10,0.01)
    f <- get.contour(x=A,y=M,n=n)
    contour(f,nlevels=20,levels=levels,col=1,add=TRUE, cex=cex,cex.lab=cex.lab)
  }
  return()
}

