#include "R.h"
#include "Rmath.h"
#include "Rinternals.h"
# include "math.h"

/************************************************************************/
/* Note: indices are zero-based */

#define DTOL  1e-12   /* Minimum floating-point error */
double corr(int nn, int *xx, int *yy); 
double  MAX(int nn, double *xx) ;
void merge_quant(int *q1_o, int *q2_o, int *nbin_o, int *n,  
		 int *q1_n, int *q2_n, int *nbin_n);
void get_max_corr(int *q1_o, int *q2_o, int *nbin_o, int *n,  
		  int *q1_n, int *q2_n, int *nbin_n); 

void merge_quant(int *q1_o, int *q2_o, int *nbin_o, int *n,  
		 int *q1_n, int *q2_n, int *nbin_n) {        /* output */
  int j, i; 
  double cl[*nbin_o-1];
  
  double cor_o = fabs(corr(*n, q1_o, q2_o));
  // Rprintf("old correlation is %e (using pointers): \n", cor_o);
  
  //  Rprintf("nbin_o is %d \n", *nbin_o);
  for ( j = 1; j < *nbin_o; j++) {
    // Rprintf("j is %d \n", j);
    for (i =0; i < *n; i++) {
      q1_n[i] = q1_o[i];    q2_n[i] = q2_o[i]; 
      //      // Rprintf("q1_n[ %d ] is %d \n", i, q1_n[i]);
      if (q1_n[i] > j) q1_n[i]--;
      if (q2_n[i] > j) q2_n[i]--;
      //      // Rprintf("q1_n[ %d ] is %d \n", i, q1_n[i]);
    }
    cl[j-1] = fabs(corr(*n,q1_n, q2_n)); 
    // Rprintf("cl %e: \n", cl[j-1]);
  }
  
  int np = *nbin_o-1;

  double cmax  = MAX(np, cl);
  int imax ; 
  // Rprintf(" cmax is %f \n", cmax);
  for ( j = 1; j < *nbin_o; j++) { 
    if (cl[j-1] == cmax) break;
  }
  imax = j;

  // Rprintf(" cmax is %f \n", cmax);
  // Rprintf(" imax is %d \n", imax);

  if (cmax >= cor_o) {
    for (i =0; i < *n; i++) {
      q1_n[i] = q1_o[i];    q2_n[i] = q2_o[i]; 
      if (q1_n[i] > imax) q1_n[i]--;
      if (q2_n[i] > imax) q2_n[i]--;
    }
    *nbin_n = *nbin_o -1; 
  }  else{
    for (i =0; i < *n; i++) {
      q1_n[i] = q1_o[i];    q2_n[i] = q2_o[i]; 
    }
    *nbin_n = *nbin_o;
  }
  // Rprintf("old nbin = %d:\n", *nbin_o); 
  // Rprintf("new nbin = %d:\n", *nbin_n); 

  // Rprintf("old q1 = %d:\n", q1_o[10]); 
  // Rprintf("new q1 = %d:\n", q1_n[10]); 

  // Rprintf("old q1 = %d:\n", q1_o[12]); 
  // Rprintf("new q1 = %d:\n", q1_n[12]); 

}

/* #double get_pearson_corr(int nn, const double *xx, const double *yy) */ 
double corr(int nn, int *xx, int *yy)
{ 
  int i;
  double sx,sy, xmean,ymean, sxx,sxy,syy;
  // Rprintf("   In function corr: \n");
/*  Rprintf("nn is %d: \n", nn);
  Rprintf("xx is %d: \n", xx[1]);
  Rprintf("yy is %d: \n", yy[1]);
*/ 
  sx=sy=sxx=sxy=syy=0.0;
  /* First find the means */
  for (i=0; i<nn; i++)
    { sx+=xx[i];  sy+=yy[i]; }
  xmean=sx/nn;  ymean=sy/nn;
  /* Now the two variances and the covariance */
  /* Note that cx and cy are centered at their means */
  for (i=0; i<nn; i++)
    { double cx=xx[i]-xmean,  cy=yy[i]-ymean;
      sxx+=cx*cx;  sxy+=cx*cy;  syy+=cy*cy; }
  if (sxx<DTOL || syy<DTOL)
    { printf("Variance of X or Y is zero!\n");  exit(1); }
  return  sxy/sqrt(sxx*syy); 
}


double MAX(int nn, double *xx) 
{
  int i;
  double  xmax = xx[0];
  
  for (i=0; i<nn; i++) {
    //  Rprintf(" cl[%d] is %f \n", i, xx[i]);
    if (xmax < xx[i]) {
      xmax = xx[i]; 
    }
  }  
  //  Rprintf(" xmax is %f \n", xmax);
  return(xmax);
}

void get_max_corr(int *q1_o, int *q2_o, int *nbin_o, int *n,  
		  int *q1_n, int *q2_n, int *nbin_n) {        /* output */
  int i,j;

  //  for (i = 0; i < 15; i++)    Rprintf("q1_o[%d] : %d ; q1_n[%d]: %d \n",i, q1_o[i],i, q1_n[i]); 

  //  Rprintf("nbin_o: %d \n", *nbin_o); 
  //Rprintf("n: %d \n", *n); 

  //  Rprintf("nbin_n: %d \n", *nbin_n); 

  for (j = *nbin_o; j > 1; j--) {
    Rprintf("number of bins : %d \n", j); 
    merge_quant(q1_o, q2_o, nbin_o, n, 
		q1_n, q2_n, nbin_n);
    
    for (i =0; i <= *n-1; i++) {
      q1_o[i] = q1_n[i];    q2_o[i] = q2_n[i]; 
    }
    *nbin_o = *nbin_n;
    if (*nbin_n == j) break;
  }
}
