#Figures in QCC manuscript

source("../R/qcc_functions.R")
dyn.load("../src/MaxCorr.Quantization.so") # unix 
source("../R/MaxCorr.Quantization.R")

#n <- 300000; ran1 <- rnorm(n); ran2 <- rnorm(n)
#save(n, ran1,ran2, file = "../data/ran.RData")

load(file = file.path("../data", "ran.RData"))
  (n <- length(ran1)) # number of probes in simulation: 300000; 
load(file = file.path("../data", "data.Y63.RData"))
load(file = file.path("../data", "data.wt.1.RData"))

nbin = 100;

# It takes time to prepare data for figures, and these data have been saved as RData files already.
# So we can skip this part. 
prepareDataForFig1_Fig3 <- function(nbin=100)  {  
  # sas: signal amounts (coverage)
  # sis: signal intensities (SNR) 
  sas <- seq(0.05, 0.5, 0.05); names(sas) <- sas;   sis <- 2:6; names(sis) <- sis
#  sas <- seq(0.05, 0.1, 0.05); names(sas) <- sas;   sis <- 2:3; names(sis) <- sis

  cor.mat <- matrix(0, nrow = length(sas), ncol=length(sis)) ;  dimnames(cor.mat) <- list(sas, sis)
  cor.mat.n <- cor.mat
  cor.mat.list <- list(Pearson = cor.mat,
                       Spearman = cor.mat,
                       Quantized = cor.mat)
    
  #par(mfrow=c(1,2))
  i=3;j =5;     si <- sis[j];        sa <- sas[i]  ;

  # It takes a while to complete these loop 
  for (j in 1:length(sis)) {
    si <- sis[j]
    for (i in 1:length(sas)) {
      sa <- sas[i]
      ns <- n*sa
      dat0 <- rep(0, n);
      
      dat0[10+(1:ns)] <- si

      data <- cbind(r1 = addNoise(dat0,ran=ran1),r2= addNoise(dat0,ran=ran2))
      
      colnames(data) <- 
        paste(colnames(data), "(", sa*100, "%;S/N:", si, ")", sep="")

      gc();      system.time(
                             junk <- scat.plot.quantization(data= data, nbin=nbin,plot=F)
                             )
      str(junk)
      cor.mat.list$Pearson[i,j]       <- 
        round(cor(data,method = "pearson")[1,2],3)
      cor.mat.list$Spearman[i,j]       <- 
        round(cor(data,method = "spearman")[1,2],3)
      cor.mat.list$Quantized[i,j]  <-
        round(junk[[2]],3)
    }
  }

  cor.mat.list.RData <-
    paste("RData/cor.mat.list.nbin",nbin, ".RData",sep ="")
 cor.mat.list.RData
#  save(cor.mat.list, file=cor.mat.list.RData)
  load(file=cor.mat.list.RData)

  cor.mat.o <- cor.mat.list$Pearson; cor.mat.n <- cor.mat.list$Quantized
    
  x =     as.numeric(rownames(cor.mat.o))  *100

  main <-
    paste("Initial number of bins: ", nbin, sep="")

  j=1; plot(x= x, y = cor.mat.o[,j], main = main,
    xlab = "Signal amount (%)", ylab = "correlation coeff.",
    pch=".", col=j,ylim=c(0,1), lty=2)
  for (j in 1:ncol(cor.mat.o)) points(x= x, y = cor.mat.o[,j],  pch=20, type="b",
                                     col=j, lty=2)
  for (j in 1:ncol(cor.mat.n)) points(x= x, y = cor.mat.n[,j],  pch=20, type="b",
                                     col=j, lty=1)

  legend("bottomright", legend= paste("S/N = ", colnames(cor.mat.o),sep=""), text.col=1:ncol(cor.mat.o))
  legend("bottom", legend= c("raw", "quantization"), lty = 2:1)
  dev.off()
  print(c("nbin", nbin))
} # End of prepareDataForFig1_Fig3


Fig1_Fig2 <- function() {


# png("Figures/Fig1.png", width=1200, height=400)
#  pdf("Figures/Fig1.pdf", width=10, height=3.5)
  postscript("Figures/Fig1.eps", width=12, height=4)

  nbin=100;   cor.mat.list.RData <-   paste("RData/cor.mat.list.nbin",nbin, ".RData",sep ="")
  load(file=cor.mat.list.RData)

  get.Fig1()
  dev.off()
  ii=c(1,4)
  ind.sas=c(1,4)
  sas
  get.Fig1 <- function(ind.sas=c(1,4)) {
    # sas: signal amounts (coverage)
    # sis: signal intensities (SNR) 
    sas <- seq(0.05, 0.5, 0.05); names(sas) <- sas;   sis <- 2:6; names(sis) <- sis
    sas.ii <- sas[ind.sas]
    
    par(mfrow=c(1,length(sas.ii)+1))
    lapply(sis["3"], function(si)  {
      for (i in 1:length(sas.ii)) {
        sa <- sas.ii[i]
#      lapply(sas[c(1,4)], function(sa) {
        ns <- n*sa
        dat0 <- rep(0, n);
    
        dat0[10+(1:ns)] <- si
        
        data <- cbind("#1" = addNoise(dat0,ran=ran1),"#2" = addNoise(dat0,ran=ran2))
        colnames(data) <-
          paste("Simulation replicate ", colnames(data), sep="")
         # paste("rep", colnames(data), "(Signal amount:", sa*100, "%;S/N:", si, ")", sep="")
        round(cor(data)[1,2],3)
        main = paste("Corr. Coeff.: ",  round(cor(data)[1,2],3),  " ( amount:", sa*100, "%; S/N:", si, ")", sep="")
         # paste("Corr. Coeff.: ",  round(cor(data)[1,2],3), sep="")
        scat.plot(data=data,index=NULL,main=main,xlim=c(-4,8), ylim=c(-4,8))
        
        mtext(LETTERS[i], side=3,adj=-0.1,cex=1.5,line=2,font=2)
      }   
#      })
    })

    cor.mat.o <- cor.mat.list$Pearson
    x =     as.numeric(rownames(cor.mat.o))  *100
    
    j=1; plot(x= x, y = cor.mat.o[,j],  cex = 1.5, cex.lab = 1.5, 
      xlab = "Signal amount (%)", ylab = "correlation coeff.",
      pch=".", col=j,ylim=c(0,1), lty=2)
    for (j in 1:ncol(cor.mat.o)) points(x= x, y = cor.mat.o[,j], pch=20, type="b",
                                     col=j, lty=2)
 # for (j in 1:ncol(cor.mat.n)) points (x= x, y = cor.mat.n[,j], col=j, lty=1)

    legend("bottomright", legend= paste("S/N = ", colnames(cor.mat.o),sep=""), text.col=1:ncol(cor.mat.o))
#  legend("bottom", legend= c("raw", "quantization"), lty = 2:1)
    i=length(sas.ii)+1;
    mtext(LETTERS[i], side=3,adj=-0.1,cex=1.5,line=2,font=2)
  } # End of get.Fig1
  

#  png("Figures/Fig2.png", width=1200, height=400)
#  pdf("Figures/Fig2.pdf", width=10, height=3.5)
  # postscript("Figures/Fig2.eps", width=12, height=4)
  get.Fig2(2:4)
  dev.off()
 
  str(cor.mat.list)
  ind.sis=1:3
  
  get.Fig2 <- function(ind.sis=1:3) {
    n.cor=
      names(cor.mat.list)
    sis <-
      colnames(cor.mat.list[[1]])
    print(sis)
    sis <- sis[ind.sis]
    par(mfrow=c(1,length(sis)))
    
    si <- sis[1]
    for (ii in 1:length(sis)) {
      si=sis[ii]
#    lapply(sis, function(si)  {
      
      print(si)
      main = paste("S/N: ", si, sep="")
      i=1; x =     as.numeric(rownames(cor.mat.list[[i]]))  *100
       cor.mat.list[[i]]
      plot(x= x, y = cor.mat.list[[i]][,si],  cex = 1.5, cex.lab = 1.5, main=main,
        xlab = "Signal amount (%)", ylab = "correlation coeff.",
        pch=".", col=i,ylim=c(0,1), lty=2)      

      for (i in 1:length(cor.mat.list)) points(x= x, y = cor.mat.list[[i]][,si], pch=20, type="b",
                                          col=i, lty=2)
      legend("bottomright", legend= paste( names(cor.mat.list),sep=""), text.col=1:length(cor.mat.list))
       mtext(LETTERS[ii], side=3,adj=-0.1,cex=1.5,line=2,font=2)
    }
#    })
  }
    str(cor.mat.list)
}

#rm(list=ls())
Fig3 <- function() {
  nbin = 400

  collectDataForFig3 <- function() {
    load(file = file.path("../data", "ran.RData"))
    sas <- seq(0.05, 0.5, 0.15); names(sas) <- sas # signal amount(s) 
    sis <- 2:6; names(sis) <- sis  # signal intensity (s)

    i=1; j=1; si =sis[i]; sa=sas[j]
    nbin
    str(data)
    nbins <- c(25, 50, 100,200,400); names(nbins) <- nbins
    n = 300000
    dir("../data",pattern="nbin")
    
    cor.mat.nbin.list <-  lapply(nbins, function(nbin) {
      print(nbin)
      cor.mat.list.RData <-
        paste("../data/cor.mat.list.nbin",nbin, ".RData",sep ="")
      load(file=cor.mat.list.RData)
      return(cor.mat.list)
    })
    
    
    str(  cor.mat.nbin.list)
    
    str(  sis <-     colnames( cor.mat.nbin.list[[1]][[3]])); names(sis) <- sis
    str(sas <-  rownames( cor.mat.nbin.list[[1]][[3]]))
    str(nbins <- names(cor.mat.nbin.list))
    
    cor.mat.nbinEffect.list <- lapply(sis, function(si) {
      cor.mat <- NULL
      for (sa in sas) {
        cor.mat <- cbind(cor.mat,
                         unlist(lapply(nbins, function(nbin) {
                           cor.mat.nbin.list[[nbin]][[3]][sa,si]
                         })
                                ))
      }
      
      rownames(cor.mat) <- nbins; colnames(cor.mat) <- sas
      
      return(cor.mat)
    })
    
    str(  cor.mat.nbinEffect.list)
#  save(cor.mat.nbinEffect.list, file="../data/cor.mat.nbinEffect.list.RData")

  } # End of  collectDataForFig3
  
 

postscript("Figures/Fig3.eps", width=12, height=4)
   load(file="../data/cor.mat.nbinEffect.list.RData")
  get.Fig3(ind.sis=2:4,ylim=c(0.5,1))
  dev.off()
  
  get.Fig3 <- function(ind.sis = 2:4, ind.sas=seq(1,10,3),ylim=c(0,1)) {
    par(mfrow=c(1,length(ind.sis)))
    sis <- 
      names(cor.mat.nbinEffect.list)
    sis <- sis[ind.sis]
    sas <- 
        colnames(cor.mat.nbinEffect.list[[2]])
      sas
   #   str(cor.mat.nbinEffect.list)
       sa <- sas[1]
    length(sis)
    ii=1
    for (ii in 1:length(sis)) {
      si = sis[ii]
#      lapply(sis, function(si)  {
        print(si)
        main = paste("S/N: ", si, sep="")
        x =  nbins =   as.numeric(rownames(cor.mat.nbinEffect.list[[si]]))
        x
        i=1; sa <- sas[ind.sas[i]];  plot(x= x, y = cor.mat.nbinEffect.list[[si]][,sa],
          cex = 1.5, cex.lab = 1.5, main=main,
          xlab = "Initial number of bins", ylab = "Quantized corr. coeff.",
          pch=".", col=1,ylim=ylim, lty=2)      
        
        for (i in 1:length(ind.sas)) {
          sa <- sas[ind.sas[i]];
          points(x= x,  cor.mat.nbinEffect.list[[si]][,sa],
                 pch=20, type="b", col=i, lty=2)
        }
        legend <-
          paste("Signal amount: ", as.numeric(sas[ind.sas])*100,"%", sep="")
        legend("bottomright", legend=legend, text.col=1:length(legend))
      mtext(LETTERS[ii], side=3,adj=-0.1,cex=1.5,line=2,font=2)
    }
#           return()   })
      return()
    }
  
  str(cor.mat.nbinEffect.list)
}
  

Fig4_Fig5<- function() {

  QCC.Y63 <- scat.plot.quantization(data=data.Y63,nbin=100)

#  postscript("Figures/Fig4.eps", width=12, height=6)
  junk <- scat.plot.quantization(data=data.Y63,QCC=QCC.Y63)
  dev.off()

  QCC.wt.1 <- scat.plot.quantization(data=data.wt.1,nbin=100)
  
#  postscript("Figures/Fig5.eps", width=12, height=6)
  junk <- scat.plot.quantization(data=data.wt.1,QCC=QCC.wt.1,nbin=50)
  dev.off()

}

Fig.4.X <- function() {

# The Pearson correlation coefficient and QCC for ONLY THE SIGNAL PROBES (Tuba's Y63)
  cor(data.Y63)[1,2]    # 0.380
  cor(data.Y63[index.X.F,])[1,2]   # 0.45  for X
  
  system.time(QCC.Y63 <- scat.plot.quantization(data=data.Y63,nbin=100))  # 30 seconds
  
  data.Y63.X <- data.Y63[index.X.F,];

  QCC.Y63.X <- scat.plot.quantization(data=data.Y63.X,nbin=100) 

 # postscript("Figures/QCC.Y63.X.eps", width=8, height=4)
  junk <- scat.plot.quantization(data=data.Y63.X,QCC=QCC.Y63.X)
  dev.off()

#  png("Figures/QCC.Y63.png", width=800, height=450)
#  junk <- scat.plot.quantization(data=data.Y63,QCC=QCC.Y63)
#  dev.off() 
}
